% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/k-mer-based.R
\name{generate_permuted_enrichments}
\alias{generate_permuted_enrichments}
\title{Generate Random Permutations of the Enrichment Data}
\usage{
generate_permuted_enrichments(
  n_transcripts_foreground,
  background_set,
  k,
  n_permutations = 1000,
  n_cores = 4
)
}
\arguments{
\item{n_transcripts_foreground}{number of transcripts in the original
foreground set}

\item{background_set}{character vector of DNA or RNA sequences that
constitute the
background set}

\item{k}{length of \emph{k}-mer, either \code{6} for hexamers or
\code{7} for heptamers}

\item{n_permutations}{number of permutations to perform}

\item{n_cores}{number of computing cores to use}
}
\value{
The result of \code{\link{calculate_kmer_enrichment}} for the
random foreground sets.
}
\description{
Calculates \emph{k}-mer enrichment values for randomly sampled (without
replacement) foreground sets.
}
\seealso{
Other \emph{k}-mer functions: 
\code{\link{calculate_kmer_enrichment}()},
\code{\link{check_kmers}()},
\code{\link{compute_kmer_enrichment}()},
\code{\link{count_homopolymer_corrected_kmers}()},
\code{\link{draw_volcano_plot}()},
\code{\link{estimate_significance}()},
\code{\link{estimate_significance_core}()},
\code{\link{generate_kmers}()},
\code{\link{run_kmer_spma}()},
\code{\link{run_kmer_tsma}()}
}
\concept{\emph{k}-mer functions}
