% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{init_iupac_lookup_table}
\alias{init_iupac_lookup_table}
\title{Initializes the IUPAC lookup table}
\usage{
init_iupac_lookup_table()
}
\value{
an environment, the IUPAC lookup hash table
}
\description{
Initializes a hash table that serves as a IUPAC lookup table for the
\code{\link{generate_iupac_by_matrix}} function.
}
\details{
IUPAC RNA nucleotide code:
\tabular{rl}{
  \code{A} \tab Adenine\cr
  \code{C} \tab Cytosine\cr
  \code{G} \tab Guanine\cr
  \code{U} \tab Uracil\cr
  \code{R} \tab A or G\cr
  \code{Y} \tab C or U\cr
  \code{S} \tab G or C\cr
  \code{W} \tab A or U\cr
  \code{K} \tab G or U\cr
  \code{M} \tab A or C\cr
  \code{B} \tab C or G or U\cr
  \code{D} \tab A or G or U\cr
  \code{H} \tab A or C or U\cr
  \code{V} \tab A or C or G\cr
  \code{N} \tab any base
}
}
\examples{
generate_iupac_by_matrix(get_motif_matrix(get_motif_by_id("M178_0.6")[[1]]),
  code = init_iupac_lookup_table())
}
\references{
\url{http://www.chem.qmul.ac.uk/iubmb/misc/naseq.html}
}
\seealso{
Other motif functions: 
\code{\link{generate_iupac_by_kmers}()},
\code{\link{generate_iupac_by_matrix}()},
\code{\link{generate_kmers_from_iupac}()},
\code{\link{get_motif_by_id}()},
\code{\link{get_motif_by_rbp}()},
\code{\link{get_motifs}()},
\code{\link{get_motifs_meta_info}()},
\code{\link{get_ppm}()},
\code{\link{set_motifs}()}
}
\concept{motif functions}
