% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_matrix.R
\name{read_matrix}
\alias{read_matrix}
\title{Import motifs from raw matrices.}
\usage{
read_matrix(file, skip = 0, type, positions = "columns",
  alphabet = "DNA", sep = "", headers = TRUE, rownames = FALSE,
  comment = NULL)
}
\arguments{
\item{file}{\code{character(1)} File name.}

\item{skip}{\code{numeric(1)} If not zero, will skip however many desired lines in the
file before starting to read.}

\item{type}{\code{character(1)} One of \code{c('PCM', 'PPM', 'PWM', 'ICM')}.
If missing will try and guess which one.}

\item{positions}{\code{character(1)} One of \code{c('columns', 'rows')}. Partial matching
allowed. Indicate whether each
position within a motif is represented as a row or a column in the file.}

\item{alphabet}{\code{character(1)} One of \code{c('DNA', 'RNA', 'AA')},
or a string of letters.}

\item{sep}{\code{character(1)} Indicates how individual motifs are separated. Set as
\code{NULL} if there are no seperating lines between motifs (the default is to
assume a blank line).}

\item{headers}{\code{logical(1)}, \code{character(1)} Indicating if and how to read names.}

\item{rownames}{\code{logical(1)} Are there alphabet letters present as rownames?}

\item{comment}{\code{NULL}, \code{character(1)} Character denoting lines to be considered
comments.}
}
\value{
\code{list} \linkS4class{universalmotif} objects.
}
\description{
Import simply formatted motifs.
}
\examples{
   hocomoco <- system.file("extdata", "hocomoco.txt", package = "universalmotif")
   hocomoco <- read_matrix(hocomoco, headers = ">", positions = "rows")

}
\seealso{
Other read_motifs: 
\code{\link{read_cisbp}()},
\code{\link{read_homer}()},
\code{\link{read_jaspar}()},
\code{\link{read_meme}()},
\code{\link{read_motifs}()},
\code{\link{read_transfac}()},
\code{\link{read_uniprobe}()}
}
\author{
Benjamin Jean-Marie Tremblay, \email{benjamin.tremblay@uwaterloo.ca}
}
\concept{read_motifs}
