% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim_motifs.R
\name{trim_motifs}
\alias{trim_motifs}
\title{Trim motifs.}
\usage{
trim_motifs(motifs, min.ic = 0.25, trim.from = c("both", "left", "right"))
}
\arguments{
\item{motifs}{See \code{\link[=convert_motifs]{convert_motifs()}} for acceptable formats.}

\item{min.ic}{\code{numeric(1)} Minimum allowed information content. See
\code{\link[=convert_type]{convert_type()}} for a discussion on information content.}

\item{trim.from}{\code{character(1)} Control the direction of trimming.}
}
\value{
Motifs See \code{\link[=convert_motifs]{convert_motifs()}} for available output
formats.
}
\description{
Remove edges of motifs with low information content. Currently does
not trim \code{multifreq} representations.
}
\examples{
jaspar <- read_jaspar(system.file("extdata", "jaspar.txt",
                                  package = "universalmotif"))
jaspar.trimmed <- trim_motifs(jaspar)

}
\seealso{
\code{\link[=create_motif]{create_motif()}}, \code{\link[=convert_type]{convert_type()}}
}
\author{
Benjamin Jean-Marie Tremblay, \email{benjamin.tremblay@uwaterloo.ca}
}
